



* GÉNERO

	/* Se procede a eliminar 32 observaciones cuyo genero es "inconsistent"
	
	Se procede también a eliminar las observaciones que vienen de xvdat pero que corresponden a gente que no se entrevisto para UKHLS*/

gen female=sex_dv 

recode female 2=1 1=0

lab def fem 1 "Female", add
lab def fem 0 "Male", add

lab val female fem

tab sex_dv female

recode female -9=. -20=.
tab female


* MARITAL STATUS
	
		/// Esta variable es importante porque debe ayudar en la selección de la muestra de análisis. La primera categoría es de menores de 16 años.
		
		/// Se recomendó usar mastat_dv, en vez de marstat_dv (ver mensaje del equipo de apoyo de Und.Soc.)
	
tab marstat_dv
gen maritalst=marstat_dv

		/// Simplificación de la variables
		
		recode maritalst (3/6=0), gen(couple)

		lab def pareja 0 "Not in couple", add
		lab def pareja 1 "Married", add
		lab def pareja 2 "Cohabitation", add
		
		lab val couple pareja

recode couple (0=0 "single") (1/2 = 1 "couple"), gen (relationship) 


* EDUCACIÓN

	/* La única variable realmente hábil en esta sección es 'hiqual_dv'. Es una variable que permite la reproducción del método de computación de la sobreeducación (método ORU) seguido por Witeveen (2022). De todos modos, el cruce con otra variable más detallada pero menos hábil (qfhigh_dv) refleja inconsistencias que deberían ser consultadas en el foro de ayuda */
	
	/* Finalmente, siguiendo a Witeveen (2022), se podrían extraer seis niveles educativos (1. GCSE o menos / 2. A-LEVEL / 3.Teaching qualification with no PGCE / 4.Diploma in HE / 5. First degree + nursing qualification 6.Higher degree). A esos niveles habría que asignarlas un número de años, de acuerdo con Witeveen (2022) */

tab qfhigh_dv hiqual_dv
tab nhiqual_dv hiqual_dv

gen highest_educ=hiqual_dv

recode highest_educ 4/9=1 3=2 2=3 1=5

	/// Variable con tres niveles
	
recode highest_educ 1=1 2/4=2 5/6=3, gen(highest_educ3)

lab def HE3 1 "Basic", add
lab def HE3 2 "Middle", add
lab def HE3 3 "High", add

lab val highest_educ3 HE3

tab highest_educ3


* PARTNER'S EDUCATION

gen _sp_highest_educ=_sp_hiqual_dv
recode _sp_highest_educ (4/9=1) (3=2) (2=3) (1=5) 

replace _sp_highest_educ = 0 if relationship==0

tab _sp_highest_educ

label define educ_label 0 "nopartner", add
label define educ_label 1 "Degree", add 
label define educ_label 2 "Other higher", add 
label define educ_label 3 "A level etc", add 
label define educ_label 4 "GCSE etc", add 
label define educ_label 5 "Other qual", add 
label define educ_label 9 "No qual", add 

label values _sp_highest_educ educ_label

tab _sp_highest_educ

	/// Variable resumen (university graduation vs.less) 

recode _sp_highest_educ 0=0 1/4=1 5/6=2, gen(_sp_highest_educ3)

lab def _sp_higher_edu 0 "No partner", add 
lab def _sp_higher_edu 1 "Less than HE", add
lab def _sp_higher_edu 2 "Higher educ", add

lab val _sp_highest_educ3 _sp_higher_edu



*-------------------------------------*
* Step 1: Create 4-group variable
*-------------------------------------*
gen gndr_educ_group = .
replace gndr_educ_group = 1 if female == 0 & highest_educ3 == 2  // Men (Mid)
replace gndr_educ_group = 2 if female == 0 & highest_educ3 == 3  // Men (High)
replace gndr_educ_group = 3 if female == 1 & highest_educ3 == 2  // Women (Mid)
replace gndr_educ_group = 4 if female == 1 & highest_educ3 == 3  // Women (High)
label define group_lbl 1 "Men (Mid)" 2 "Men (High)" 3 "Women (Mid)" 4 "Women (High)"
label values gndr_educ_group group_lbl



table gndr_educ_group _sp_highest_educ3 if highest_educ3 > 1, statistic(percent gndr_educ_group) nformat(%5.1f)


